using System;

using Microsoft.DirectX.Direct3D;
using Microsoft.DirectX;
using Microsoft.DirectX.DirectInput;

using DarkStrideToolbox;


namespace DarkStride.StellarLanes.SharedDLL
{
	public class WaveManager
	{
		#region Member Variables
		private const double m_cTIMETODISPLAYWAVE = 4;
		private const double m_cTIMETOFADEOUT = 3;

		private DSGameEngine m_oGameEngine = null;
		//private DSSortedList m_oEntitys = null;
		private double m_nCurrentTime = 0;
		private double m_nTimeOfLastWaveCheck = -20;

		private long m_nCurrentWave = 0;
		private DSSortedList m_oEntitysForWave = new DSSortedList();

		private bool m_bHaveNotifiedPlayerOfCurrentWave = false;
		private bool m_bDisplayingWaveMsg = false;
		private string m_sWaveMsg = string.Empty;
		private double m_nTimeOfMsgDisplayStart = 0;

		private bool m_bActive = true;
		#endregion


		public WaveManager()
		{
		}
		public void Render2DAfterForms()
		{
			string sMsg = string.Empty;
			System.Drawing.Color oColor = System.Drawing.Color.White;
			double nTimeIntoWave = m_nCurrentTime - m_nTimeOfMsgDisplayStart;
			Microsoft.DirectX.Direct3D.Font oFont = null;


			if( m_bDisplayingWaveMsg == true )
			{
				if( nTimeIntoWave < m_cTIMETODISPLAYWAVE )
				{
					oColor = GraphicConstants.m_cBASICCOLOR;
				}
				else
				{
					oColor = System.Drawing.Color.FromArgb( 
								(int)( 255 * ( 1 - ( nTimeIntoWave-m_cTIMETODISPLAYWAVE) / m_cTIMETOFADEOUT ) ),
								GraphicConstants.m_cBASICCOLOR.R,
								GraphicConstants.m_cBASICCOLOR.G,
								GraphicConstants.m_cBASICCOLOR.B );
				}

				oFont = DSResourceManager.GetGlobalInstance().GetFont( GraphicConstants.m_cSLFONTBIG ); 
				Globals.Inst().GameEngine.RenderText( oFont,
						Globals.Inst().GameEngine.ScreenWidth / 2.0 - ( m_sWaveMsg.Length / 2.0 ) * 20,100,
						oColor,m_sWaveMsg );

				sMsg = GetWaveDescription( m_nCurrentWave );
				Globals.Inst().GameEngine.RenderText( oFont,
						Globals.Inst().GameEngine.ScreenWidth / 2.0 - ( sMsg.Length / 2.0 ) * 20,130,
						oColor,sMsg );
			}
			else
			{
				oFont = DSResourceManager.GetGlobalInstance().GetFont( GraphicConstants.m_cSLFONT ); 

				Globals.Inst().GameEngine.RenderText( oFont,
					Globals.Inst().GameEngine.ScreenWidth - m_sWaveMsg.Length * 11,0,
					GraphicConstants.m_cBASICCOLOR,m_sWaveMsg );

				sMsg = GetWaveDescription( m_nCurrentWave );
				Globals.Inst().GameEngine.RenderText( oFont,
					Globals.Inst().GameEngine.ScreenWidth - sMsg.Length * 11,15,
					GraphicConstants.m_cBASICCOLOR,sMsg );

				
			}
		}
		public void Advance( Session oSession,double nElapsedTime )
		{
			Entity oLoopEntity = null;


			m_nCurrentTime += nElapsedTime;

			//Check for a wave change
			if( Globals.Inst().IAmTheServer == true && m_nCurrentTime - m_nTimeOfLastWaveCheck > 20.0 )
			{
				m_nTimeOfLastWaveCheck = m_nCurrentTime;

				//Are all our created minions dead?
				for( int i=0 ; i<m_oEntitysForWave.Count ; i++ )
				{
					if( i>=m_oEntitysForWave.Count ){ break; }
					oLoopEntity = (Entity)m_oEntitysForWave.GetByIndex( i );

                    if (oLoopEntity == null || oLoopEntity.IsDead == true)
					{
						m_oEntitysForWave.RemoveAt( i );
						i--;
					}
				}
				
				//Are we ready for the next wave then?
				if( ( m_nCurrentWave == 0 || m_oEntitysForWave.Count == 0 ) && m_bActive == true )
				{
                    StartNextWave(oSession,m_nCurrentWave + 1);
				}
			}

			if( Globals.Inst().IAmTheServer == false && m_bHaveNotifiedPlayerOfCurrentWave == false &&
				m_nCurrentWave != 0 )
			{
				StartWaveStartMsg();
			}

			if( m_nCurrentTime - m_nTimeOfMsgDisplayStart > m_cTIMETODISPLAYWAVE + m_cTIMETOFADEOUT && m_bDisplayingWaveMsg == true  )
			{
				m_bDisplayingWaveMsg = false;
			}
		}
		//Returns true if the message was used
		public bool DataReceived( DSNetworkPlayer oSendingPlayer,DSNetworkPacket oPacket )
		{
			bool bUsedMsg = true;

			try
			{
				if( oPacket.MsgType == (int)enumNetMsg.StartWave )
				{
					long nWaveStarting = 0;
					
					NetMsg.Rcv_StartWave( oPacket,ref nWaveStarting );
					m_nCurrentWave = nWaveStarting;
					StartWaveStartMsg();
				}
				else
				{
					bUsedMsg = false;
				}
			}
			catch( System.Exception oEx )
			{
				m_oGameEngine.WriteToDebug( 1,"Error On WaveManager.DataReceive: " + oEx.Message + "\n[" + oEx.StackTrace + "]" );
				DSMisc.ShowErrors( oEx );
			}

			return( bUsedMsg );
		}

		public void KillAllWaveEntitys()
		{
			Entity oLoopEntity = null;

			
			for( int i=0 ; i<m_oEntitysForWave.Count ; i++ )
			{
				oLoopEntity = (Entity)m_oEntitysForWave.GetByIndex( i );
				oLoopEntity.IsDead = true;
				oLoopEntity.StartFadeout( 2 );
			}

			m_nTimeOfLastWaveCheck = m_nCurrentTime - 17;
		}
		public void RemoveEntity( Entity oEntity )
		{
			if( m_oEntitysForWave.ContainsKey( oEntity.PKey ) == true )
			{
				m_oEntitysForWave.Remove( oEntity.PKey );
			}
		}

		private void StartNextWave( Session oSession,long nWaveToStart )
		{
			m_nCurrentWave = nWaveToStart;

			if( m_nCurrentWave <= 2 )
			{
                m_oEntitysForWave = SpawnNewEntitys(oSession,2 + m_nCurrentWave * 3, typeof(RedAsteroid));
			}
			else if( m_nCurrentWave <= 4 )
			{
                m_oEntitysForWave = SpawnNewEntitys(oSession, 1 + (int)((double)m_nCurrentWave * 1.25), typeof(Vux));
                AddToCurWave(SpawnNewEntitys(oSession,m_nCurrentWave, typeof(RedAsteroid)));
			}
			else if( m_nCurrentWave <= 6 )
			{
                m_oEntitysForWave = SpawnNewEntitys(oSession, (int)((double)m_nCurrentWave * .8), typeof(Shagot));
                AddToCurWave(SpawnNewEntitys(oSession,m_nCurrentWave, typeof(RedAsteroid)));
			}
            else //if (m_nCurrentWave <= 8)
            {
                m_oEntitysForWave = SpawnNewEntitys(oSession, (int)((double)m_nCurrentWave * 1.0), typeof(Vux));
                AddToCurWave(SpawnNewEntitys(oSession, (int)((double)m_nCurrentWave * 1.0), typeof(Shagot)));
                AddToCurWave(SpawnNewEntitys(oSession, m_nCurrentWave, typeof(RedAsteroid)));                
            }


			NetMsg.Send_StartWave( Globals.Inst().GameEngine.DirectPlay,m_nCurrentWave );
		}
        private void AddToCurWave(DSSortedList oNewEntitys)
        {
            foreach (Entity oLoopEntity in oNewEntitys.Values)
            {
                m_oEntitysForWave.Add(oLoopEntity.PKey,oLoopEntity);
            }
        }
		public string GetWaveDescription( long nWave )
		{
			string sDesc = string.Empty;

			if( m_nCurrentWave <= 2 )
			{
				sDesc = "Normal";
			}
			else if( m_nCurrentWave <= 2 )
			{
				sDesc = "Advanced";
			}
			else if( m_nCurrentWave <= 2 )
			{
				sDesc = "Expert";
			}

			return( sDesc );
		}
		private DSSortedList SpawnNewEntitys( Session oSession,long nNumToAdd,Type oNewType )
		{
			DSSortedList oNewEntitys = new DSSortedList();
			double nVel = 100;
            Zone oMyZone = null;
			Entity oNewEntity = null;


            //Do this better!
            oMyZone = oSession.Zones.Values[0];

			for( int i=0 ; i<nNumToAdd ; i++ )
			{
				oNewEntity = (Entity)Activator.CreateInstance( oNewType,new object[]{} );
				oNewEntity.Vel = new Vector2(	(float)( DSMisc.GetRnd() * nVel - nVel / 2.0f ),
					(float)( DSMisc.GetRnd() * nVel - nVel / 2.0f ) );
				oNewEntity.Pos = new Vector2(
                    (float)(DSMisc.GetRnd() * oSession.Width - oSession.Width / 2.0),
                    (float)(DSMisc.GetRnd() * oSession.Height - oSession.Height / 2.0));
				oNewEntity.IsWaveEntity = true;

                oMyZone.AddEntity(oSession,oNewEntity, true);
				oNewEntitys.Add( oNewEntity.PKey,oNewEntity );
			}

			
			return( oNewEntitys );
		}

		private void StartWaveStartMsg()
		{
			m_bHaveNotifiedPlayerOfCurrentWave = true;
			m_nTimeOfMsgDisplayStart = m_nCurrentTime;
			m_sWaveMsg = "Wave " + m_nCurrentWave.ToString();
			m_bDisplayingWaveMsg = true;
		}


		#region Properties
		public DSSortedList EntitysForWave
		{
			get
			{
				return( m_oEntitysForWave );
			}
			set
			{
				m_oEntitysForWave = value;
			}
		}
		public DSGameEngine GameEngine
		{
			get
			{
				return( m_oGameEngine );
			}
			set
			{
				m_oGameEngine = value;
			}
		}
		public long CurrentWave
		{
			get
			{
				return( m_nCurrentWave );
			}
			set
			{
				m_nCurrentWave = value;
			}
		}
		public bool Active
		{
			get
			{
				return( m_bActive );
			}
			set
			{
				m_bActive = value;
			}
		}
		#endregion 
	}
}
